#version 120


// ----------

uniform sampler2D composite;
varying vec4 texcoord;



uniform sampler2D depthtex0;

uniform float aspectRatio;
uniform float near;
uniform float far;

float getDepth(vec2 coord);
vec4 getBlurredColor();
vec4 getSample(vec2 coord, vec2 aspectCorrection);
vec4 getSampleWithBoundsCheck(vec2 offset);

float samples = 0.0;
float fragDepth;
float cursorDepth;
vec2 space;

void main() {
	vec4 baseColor = texture2D(composite, texcoord.st);
	gl_FragColor = baseColor;
    float gamma = 1.0;
    float rgamma = 11.65;
    float ggamma = 10.65;
    float bgamma = 11.65;
    
    float numColors = 512.0;
    float glaresize = 0.0002;
    float power = 0.225;
    vec4 c1 = texture2D(composite, texcoord.st + vec2(-0.00, 0));
    vec4 c2 = texture2D(composite, texcoord.st + vec2(0.00, 0));
    c1 = pow(c1, vec4(gamma, gamma, gamma, 0));
    c1 = c1 * numColors;
    c1 = floor(c1);
    c1 = c1 / numColors;
    c1 = pow(c1, vec4(1.0/gamma,1.0/gamma,1.0/gamma,0));
    c2 = pow(c2, vec4(gamma, gamma, gamma, 0));
    c2 = c2 * numColors;
    c2 = floor(c2);
    c2 = c2 / numColors;
    c2 = pow(c2, vec4(1.0/gamma,1.0/gamma,1.0/gamma,0));

    vec4 sum = vec4(0);
    vec4 bum = vec4(0);
    vec4 sum2 = vec4(0);
    vec4 bum2 = vec4(0);
    vec4 sum3 = vec4(0);
    vec4 bum3 = vec4(0);
    vec4 sum4 = vec4(0);
    vec4 bum4 = vec4(0);
    
    vec2 coord = vec2(texcoord);
    int j;
    int i;

    for( i= -2 ;i < 2; i++)
    {
        for (j = -1; j < 1; j++)
        {
            sum += texture2D(composite, coord + vec2(-i, -i)*glaresize) * power;
            bum += texture2D(composite, coord + vec2(-i, i)*glaresize) * power;
            sum2 += texture2D(composite, coord + vec2(i,i)*glaresize) * power;
            bum2 += texture2D(composite, coord + vec2(i, -i)*glaresize) * power;
            sum3 += texture2D(composite, coord + vec2(-i, 0)*glaresize) * power;
            bum3 += texture2D(composite, coord + vec2(i, 0)*glaresize) * power;
            sum4 += texture2D(composite, coord + vec2(0,i)*glaresize) * power;
            bum4 += texture2D(composite, coord + vec2(0, -i)*glaresize) * power;
        }
    }

    const vec3 LumCoeff = vec3(0.2125, 0.7154, 0.0721);
    vec3 AvgLumin = vec3(0.55, 0.42, 0.46);
    vec4 col = 0.80 * pow(((sum*sum*sum*0.01+bum*bum*bum*0.01+sum2*sum2*sum2*0.01+bum2*bum2*bum2*0.01+sum3*sum3*sum3*0.01+bum3*bum3*bum3*0.01+sum4*sum4*sum4*0.01+bum4*bum4*bum4*0.01) * 0.01), vec4(1.0/rgamma,1.0/ggamma,1.0/bgamma,0)) + (vec4(c1.r, c2.g, c2.b, 0) * 0.265);
    vec3 color = vec3(col.r, col.g, col.b);
    vec3 intensity = vec3(dot(color, LumCoeff));
    vec3 satColor = mix(intensity, color, 1.2);
    vec3 conColor = mix(AvgLumin, satColor, 2.34);
    
    if (texture2D(composite, coord).r < 2.0)
    {
        gl_FragColor = clamp(((sum*sum*sum*0.01+bum*bum*bum*0.01+sum2*sum2*sum2*0.01+bum2*bum2*bum2*0.01+sum3*sum3*sum3*0.01+bum3*bum3*bum3*0.01+sum4*sum4*sum4*0.01+bum4*bum4*bum4*0.01) * 0.03) + (vec4(c1.r, c2.g, c2.b, 0) * 0.15), 0.0, 1.0);
        gl_FragColor = pow(((sum*sum*sum*0.01+bum*bum*bum*0.01+sum2*sum2*sum2*0.01+bum2*bum2*bum2*0.01+sum3*sum3*sum3*0.01+bum3*bum3*bum3*0.01+sum4*sum4*sum4*0.01+bum4*bum4*bum4*0.01) * 0.005), vec4(1.0/rgamma,1.0/ggamma,1.0/bgamma,0)) + (vec4(c1.r, c2.g, c2.b, 0) * 0.325);
        gl_FragColor = clamp(vec4(conColor.r, conColor.g, conColor.b, 0.0), 0.0, 1.0);
    }

}
